import { ICON_PATH } from './constants.js';

/**
 * Fisher-Yates shuffle — returns a new array in random order.
 */
export function shuffleArray(items) {
  const result = Array.isArray(items) ? [...items] : [];
  const descendingIndexes = Array.from(
    { length: Math.max(0, result.length - 1) },
    (_, offset) => result.length - 1 - offset
  );
  for (const i of descendingIndexes) {
    const j = Math.floor(Math.random() * (i + 1));
    [result[i], result[j]] = [result[j], result[i]];
  }
  return result;
}

export function getIconUrl() {
  try {
    return chrome.runtime.getURL(ICON_PATH);
  } catch {
    return '';
  }
}
