export const svgs = {
  moveUp: '<svg viewBox="0 0 12 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M6 9V3M3 5l3-3 3 3"></path></svg>',
  moveDown: '<svg viewBox="0 0 12 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M6 3v6M3 7l3 3 3-3"></path></svg>',
  delete: '<svg viewBox="0 0 12 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M2 2l8 8M10 2l-8 8"></path></svg>',
  run: '<svg viewBox="0 0 12 12" fill="currentColor"><path d="M4 3l5 3-5 3z"></path></svg>',
  headerLogo: '<svg viewBox="0 0 108 24" width="108" height="24"><g font-family="system-ui" font-size="14" font-weight="700" text-anchor="middle"><g transform="translate(0 0)"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" fill="white">T</text></g><g transform="translate(28 0)"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" fill="white">I</text></g><g transform="translate(56 0)"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" fill="white">F</text></g><g transform="translate(84 0)"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" fill="white">A</text></g></g></svg>',
  pipelineT: '<svg viewBox="0 0 24 24" width="20" height="20"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" text-anchor="middle" fill="white" font-family="system-ui" font-size="14" font-weight="700">T</text></svg>',
  pipelineI: '<svg viewBox="0 0 24 24" width="20" height="20"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" text-anchor="middle" fill="white" font-family="system-ui" font-size="14" font-weight="700">I</text></svg>',
  pipelineF: '<svg viewBox="0 0 24 24" width="20" height="20"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" text-anchor="middle" fill="white" font-family="system-ui" font-size="14" font-weight="700">F</text></svg>',
  pipelineA: '<svg viewBox="0 0 24 24" width="20" height="20"><rect width="24" height="24" rx="3" fill="#5c3db8"/><text x="12" y="17" text-anchor="middle" fill="white" font-family="system-ui" font-size="14" font-weight="700">A</text></svg>',
  undo: '<svg viewbox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M4 7h6a4 4 0 1 1 0 8H6"></path><path d="M7 4L4 7l3 3"></path></svg>',
  redo: '<svg viewbox="0 0 16 16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 7H6a4 4 0 1 0 0 8h4"></path><path d="M9 4l3 3-3 3"></path></svg>',
  menu: '<svg viewbox="0 0 16 16" fill="currentColor"><circle cx="4" cy="8" r="1.5"></circle><circle cx="8" cy="8" r="1.5"></circle><circle cx="12" cy="8" r="1.5"></circle></svg>',
  helpClose: '<svg viewbox="0 0 12 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M2 2l8 8M10 2l-8 8"></path></svg>',
  chevron: '<svg viewbox="0 0 12 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M3 6h6M7 3l3 3-3 3"></path></svg>'
};

export function iconElement(name) {
  const wrapper = document.createElement('span');
  wrapper.innerHTML = svgs[name] || '';
  return wrapper.firstElementChild || document.createElement('span');
}

export function svgElement(name) {
  const wrapper = document.createElement('span');
  wrapper.innerHTML = svgs[name] || '';
  return wrapper.firstElementChild || document.createElement('span');
}
