import { svgs } from './svgs.js';

export const helpPanelContent = `
<h2>Getting Started</h2>
<p>Tifa is a Chrome extension for doing many different things with <b>tabs</b>, <b>windows</b>, <b>bookmarks</b>, <b>downloads</b>, <b>history</b>, <b>reading list</b>, and <b>tab groups</b>.</p>
<p>You set up commands that follow a simple pipeline:</p>
<div class="help-pipeline" aria-label="Tifa pipeline">
  <span class="help-step-badge" aria-hidden="true">${svgs.pipelineT}</span><span>Triggers</span>
  <span class="help-pipeline-arrow" aria-hidden="true">${svgs.chevron}</span>
  <span class="help-step-badge" aria-hidden="true">${svgs.pipelineI}</span><span>Items</span>
  <span class="help-pipeline-arrow" aria-hidden="true">${svgs.chevron}</span>
  <span class="help-step-badge" aria-hidden="true">${svgs.pipelineF}</span><span>Filters</span>
  <span class="help-pipeline-arrow" aria-hidden="true">${svgs.chevron}</span>
  <span class="help-step-badge" aria-hidden="true">${svgs.pipelineA}</span><span>Actions</span>
</div>
<p>You define what you want it to do (<b>actions</b>), what it acts upon (<b>items/filters</b>), and how you run it (<b>triggers</b>).</p>
<h3>Commands</h3>
<p>Create a command with <b>Add Command</b>.</p>
<p>You can run a command at any time with the play button or <b>Run Command Now</b> or you can run it with triggers.</p>
<h3>Triggers</h3>
<ul>
  <li><b>Icon:</b> Click the Tifa icon in the browser toolbar.</li>
  <li><b>Shortcut:</b> Assign a slot (A-Z), then map it in <b>Manage Extensions</b> &rarr; <b>Keyboard shortcuts</b>.</li>
  <li><b>Context:</b> Run from the right-click menu on a page, link, media element, or the toolbar icon.</li>
  <li><b>Omnibox:</b> In the URL box, type: <code>t &lt;keyword&gt;</code></li>
</ul>
<h3>Items</h3>
<p>Choose what type of items to act on: <b>Tabs</b>, <b>Tab Groups</b>, <b>Windows</b>, <b>Bookmarks</b>, <b>Downloads</b>, <b>History</b>, <b>Reading List</b>, or <b>Global</b> (no items).</p>
<h3>Filters</h3>
<p>Use filters to narrow the selection, then choose a refinement: <b>All</b>, <b>First</b>, <b>Last</b>, or <b>Random</b>.</p>
<p>Filters can be combined with <b>AND</b>/<b>OR</b> logic.</p>
<p>Press <b>Show Preview</b> to see which items would match if run now.</p>
<h3>Actions</h3>
<p>Choose one or more actions.</p>
<h3>Variables</h3>
<p>Text inputs support variable substitution. Use these placeholders and they will be replaced at runtime:</p>
<ul>
  <li><code>{{date}}</code> - Current date (YYYY-MM-DD)</li>
  <li><code>{{time}}</code> - Current time (HH-MM-SS)</li>
  <li><code>{{url}}</code> - URL of the first matched item</li>
  <li><code>{{domain}}</code> - Hostname of the first matched item's URL</li>
  <li><code>{{title}}</code> - Title of the first matched item</li>
  <li><code>{{count}}</code> - Total number of matched items</li>
  <li><code>{{index}}</code> - Current item index (during iteration)</li>
  <li><code>{{selection}}</code> - Text input from the trigger: selected text (context menu) or text after the command keyword (omnibox)</li>
  <li><code>{{link_url}}</code> - Context menu only: URL of the clicked link</li>
  <li><code>{{src_url}}</code> - Context menu only: source URL of the clicked media</li>
  <li><code>{{page_url}}</code> - URL of the page where the trigger ran</li>
  <li><code>\\{{variable}}</code> - Escape a variable so it stays literal (example: <code>\\{{url}}</code>)</li>
</ul>
`;
