export const $ = (id) => document.getElementById(id);
export const $$ = (sel, ctx = document) => [...ctx.querySelectorAll(sel)];

export function createElement(tag, props = {}) {
  const el = document.createElement(tag);
  const { children, className, html, ...attrs } = props;
  if (className) el.className = className;
  for (const [k, v] of Object.entries(attrs)) {
    if (k.startsWith('on') && typeof v === 'function') {
      el.addEventListener(k.slice(2).toLowerCase(), v);
    } else if (k === 'disabled' || k === 'checked' || k === 'selected') {
      if (v) el[k] = true;
    } else {
      el.setAttribute(k, v);
    }
  }
  if (html) {
    el.innerHTML = html;
  } else if (children) {
    for (const c of children) {
      if (c === null || c === undefined) continue;
      if (typeof c === 'string') {
        el.appendChild(document.createTextNode(c));
      } else {
        el.appendChild(c);
      }
    }
  }
  return el;
}

/**
 * Creates a DOM element from an HTML string using <template>
 */
export function fromHTML(html) {
  const template = document.createElement('template');
  template.innerHTML = html.trim();
  return template.content.firstChild;
}
