import { LOG_PREFIX } from '../constants.js';
import { getIconUrl } from '../utils.js';

export const logger = {
  info: (...args) => console.log(LOG_PREFIX, ...args),
  log: (...args) => console.log(LOG_PREFIX, ...args),
  warn: (...args) => console.warn(LOG_PREFIX, ...args),
  error: (message, ...args) => {
    console.error(LOG_PREFIX, message, ...args);
    const lastArg = args[args.length - 1];
    if (lastArg && typeof lastArg === 'object' && lastArg.notify === true) {
      logger.notify(message, 'Error');
    }
  },
  debug: (...args) => console.debug(LOG_PREFIX, ...args),
  group: (...args) => console.group(LOG_PREFIX, ...args),
  groupEnd: () => console.groupEnd(),
  notify: async (message, title = 'Alert') => {
    console.log(LOG_PREFIX, `[Notification: ${title}]`, message);
    try {
      await chrome.notifications.create({
        type: 'basic',
        iconUrl: getIconUrl(),
        title: `Tifa - ${title}`,
        message: String(message)
      });
    } catch {
      // Fallback
    }
  }
};
