export const filters = {
  bookmark: [
    {
      name: "Title",
      type: "string",
      getValue: (item) => item.title
    },
    {
      name: "URL",
      type: "string",
      getValue: (item) => item.url
    },
    {
      name: "Folder",
      type: "string",
      getValue: (item) => item._folderName || ''
    },
    {
      name: "Date Added",
      type: "datetime",
      getValue: (item) => item.dateAdded
    },
    {
      name: "Date Last Opened",
      type: "datetime",
      getValue: (item) => item.dateLastUsed
    }
  ],

  download: [
    {
      name: "Filename",
      type: "string",
      getValue: (item) => item.filename
    },
    {
      name: "Source URL",
      type: "string",
      getValue: (item) => item.url
    },
    {
      name: "State",
      type: [
        { label: "In Progress", value: "in_progress" },
        { label: "Interrupted", value: "interrupted" },
        { label: "Complete", value: "complete" }
      ],
      getValue: (item) => item.state
    },
    {
      name: "MIME Type",
      type: "string",
      getValue: (item) => item.mime
    },
    {
      name: "File Size (Bytes)",
      type: "number",
      getValue: (item) => item.fileSize
    },
    {
      name: "File Still Exists",
      type: "boolean",
      getValue: (item) => item.exists
    }
  ],

  history: [
    {
      name: "Page Title",
      type: "string",
      getValue: (item) => item.title
    },
    {
      name: "URL",
      type: "string",
      getValue: (item) => item.url
    },
    {
      name: "Visit Count",
      type: "number",
      getValue: (item) => item.visitCount
    },
    {
      name: "Last Visit Time",
      type: "datetime",
      getValue: (item) => item.lastVisitTime
    }
  ],

  reading_list: [
    {
      name: "URL",
      type: "string",
      getValue: (item) => item.url
    },
    {
      name: "Title",
      type: "string",
      getValue: (item) => item.title
    }
  ],

  tab: [
    {
      name: "URL",
      type: "string",
      getValue: (item) => item.url
    },
    {
      name: "Page Title",
      type: "string",
      getValue: (item) => item.title
    },
    {
      name: "Is Playing Audio",
      type: "boolean",
      getValue: (item) => item.audible
    },
    {
      name: "Is Muted",
      type: "boolean",
      getValue: (item) => item.mutedInfo?.muted
    },
    {
      name: "Is Pinned",
      type: "boolean",
      getValue: (item) => item.pinned
    },
    {
      name: "Is Incognito",
      type: "boolean",
      getValue: (item) => item.incognito
    },
    {
      name: "Loading Status",
      type: [
        { label: "Loading", value: "loading" },
        { label: "Complete", value: "complete" }
      ],
      getValue: (item) => item.status
    },
    {
      name: "Is Discarded (Memory Saver)",
      type: "boolean",
      getValue: (item) => item.discarded
    },
    {
      name: "Tab Position (Index)",
      type: "number",
      getValue: (item) => item.index
    },
    {
      name: "Tab Group",
      type: [
        { label: "Any Group", value: "any_group" },
        { label: "No Group", value: "no_group" }
      ],
      getValue: (item) => item.groupId === -1 ? "no_group" : "any_group"
    },
    {
      name: "Group Name",
      type: "string",
      getValue: (item) => item._groupTitle || ''
    },
    {
      name: "Group Color",
      type: [
        { label: "Grey", value: "grey" },
        { label: "Blue", value: "blue" },
        { label: "Red", value: "red" },
        { label: "Yellow", value: "yellow" },
        { label: "Green", value: "green" },
        { label: "Pink", value: "pink" },
        { label: "Purple", value: "purple" },
        { label: "Cyan", value: "cyan" },
        { label: "Orange", value: "orange" }
      ],
      getValue: (item) => item._groupColor || ''
    },
    {
      name: "Last Accessed",
      type: "datetime",
      getValue: (item) => item.lastAccessed
    }
  ],

  window: [
    {
      name: "Window State",
      type: [
        { label: "Normal", value: "normal" },
        { label: "Minimized", value: "minimized" },
        { label: "Maximized", value: "maximized" },
        { label: "Fullscreen", value: "fullscreen" }
      ],
      getValue: (item) => item.state
    },
    {
      name: "Window Type",
      type: [
        { label: "Normal", value: "normal" },
        { label: "Popup", value: "popup" },
        { label: "Panel", value: "panel" },
        { label: "App", value: "app" },
        { label: "DevTools", value: "devtools" }
      ],
      getValue: (item) => item.type
    },
    {
      name: "Is Incognito",
      type: "boolean",
      getValue: (item) => item.incognito
    },
    {
      name: "Is Focused",
      type: "boolean",
      getValue: (item) => item.focused
    },
    {
      name: "Is Always on Top",
      type: "boolean",
      getValue: (item) => item.alwaysOnTop
    },
    {
      name: "Contains Tab",
      type: "string",
      operators: ["contains"],
      getValue: (item) => (item.tabs || [])
        .map(t => t?.title || t?.url || '')
        .filter(Boolean)
        .join(' ')
    }
  ],

  group: [
    {
      name: "Title",
      type: "string",
      getValue: (item) => item.title
    },
    {
      name: "Color",
      type: [
        { label: "Grey", value: "grey" },
        { label: "Blue", value: "blue" },
        { label: "Red", value: "red" },
        { label: "Yellow", value: "yellow" },
        { label: "Green", value: "green" },
        { label: "Pink", value: "pink" },
        { label: "Purple", value: "purple" },
        { label: "Cyan", value: "cyan" },
        { label: "Orange", value: "orange" }
      ],
      getValue: (item) => item.color
    },
    {
      name: "Is Collapsed",
      type: "boolean",
      getValue: (item) => item.collapsed
    }
  ]
};
