export function createCommandId(prefix = 'cmd') {
  return `${prefix}_${Date.now()}_${Math.random().toString(36).slice(2, 9)}`;
}

export function createDefaultRandomTabCommand(id = createCommandId()) {
  return {
    id,
    name: 'Go to random tab',
    triggers: {
      icon: true,
      shortcutSlot: 'A',
      context: true,
      omnibox: 'r'
    },
    items: {
      scope: 'tab',
      selection: 'In All Windows',
      includeActiveTab: false
    },
    filters: [],
    refinement: { type: 'Random', n: 1 },
    actions: [{ id: 'activate', inputs: {} }],
    executionMode: 'silent'
  };
}

export function createDefaultFilteredHistoryCommand(id = createCommandId()) {
  return {
    id,
    name: 'Bookmark Wikipedia pages from last 7 days',
    triggers: {
      icon: false,
      shortcutSlot: 'B',
      context: true,
      omnibox: null
    },
    items: {
      scope: 'history',
      selection: 'Last 7 Days'
    },
    filters: [
      { name: 'URL', operator: 'Contains', value: 'wikipedia.org', join: 'and' },
      { name: 'URL', operator: "Doesn't contain", value: '#', join: 'and' }
    ],
    refinement: { type: 'All', n: 1 },
    actions: [{
      id: 'add_to_bookmarks',
      inputs: {
        destination: 'Custom',
        folder: 'Bookmarks Bar/Wikipedia {{date}}'
      }
    }],
    executionMode: 'silent'
  };
}

export function createDefaultState() {
  const command = createDefaultRandomTabCommand();
  const filteredCommand = createDefaultFilteredHistoryCommand();
  return {
    commands: [command, filteredCommand],
    helpPanelOpen: true,
    editingCommandId: command.id
  };
}
